unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ListBoxCoeff: TListBox;
    EditCoeff: TEdit;
    EditArgument: TEdit;
    MemoReport: TMemo;
    ButtonRun: TButton;
    ButtonAdd: TButton;
    ButtonDel: TButton;
    ButtonChange: TButton;
    Label1: TLabel;
    EditPower: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    CBoxReportCmd: TComboBox;
    ButtonReport: TButton;
    Label6: TLabel;
    procedure ButtonAddClick(Sender: TObject);
    procedure ButtonDelClick(Sender: TObject);
    procedure ButtonChangeClick(Sender: TObject);
    procedure ButtonRunClick(Sender: TObject);
    procedure ListBoxCoeffClick(Sender: TObject);
    procedure ButtonReportClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

//--------------------------------------------------
//    
//--------------------------------------------------

//    Edit.Text  
function TestEditTextToFloat (RqEdit : TEdit) : boolean;
var TestReal  : double;
begin
  Result := False;     //   
  try
    TestReal := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    RqEdit.Text := FloatToStr(TestReal);
    Result := True;    //   
  except
    RqEdit.Color := clCream;
    ShowMessage('    ');
  end;
end;

//        
function ProStrToFloat (RqStr   : string;
                    var RqFloat : double) : boolean;
begin
  Result  := False;     //   
  try
    RqFloat := StrToFloat(RqStr);
    Result  := True;    //   
  except
    ShowMessage('    ');
  end;
end;

//     
procedure ShowCoeffToReport (RqCoeff   : TStrings;
                             RqReport  : TMemo);
var Ind  : integer;
    WStr : string;
begin
 if RqCoeff.Count > 0
 then begin
    WStr := ': ';
    for Ind :=0 to RqCoeff.Count -1 do
    begin
      WStr := WStr + 'c' + IntToStr(Ind)
                   + '=' + RqCoeff.Strings[Ind]
                   + ';  ';
    end;
    RqReport.Lines.Add(WStr);
 end
 else begin
    RqReport.Lines.Add('  ');
 end;
end;

//     , 
//     TStrings;
function CalcPolynom (RqCoeff    : TStrings;
                      RqArgument : double): double;
var Coeff  : double;  //   
    XPower : double;  //      
    Ind    : integer; //   
begin
 Result := 0;
 if RqCoeff.Count > 0
 then begin
   XPower := 1;
   for Ind := 0 to RqCoeff.Count - 1 do
   begin
      Coeff  := StrToFloat(RqCoeff.Strings[Ind]);
      Result := Result + Coeff * XPower;
      XPower := XPower * RqArgument;
   end;
 end;
end;

//--------------------------------------------------
//      
//--------------------------------------------------

//   
procedure TForm1.ButtonAddClick(Sender: TObject);
begin
  if TestEditTextToFloat(EditCoeff)
  then ListBoxCoeff.Items.Add(EditCoeff.Text);
end;

//   
procedure TForm1.ButtonDelClick(Sender: TObject);
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    ListBoxCoeff.Items.Delete(ListBoxCoeff.ItemIndex);
    EditCoeff.Text := '';
    EditPower.Text := '';
  end;
end;

//     
procedure TForm1.ListBoxCoeffClick(Sender: TObject);
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    EditCoeff.Text := ListBoxCoeff.Items[ListBoxCoeff.ItemIndex];
    EditPower.Text := IntToStr(ListBoxCoeff.ItemIndex);
  end;
end;

//   
procedure TForm1.ButtonChangeClick(Sender: TObject);
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    if TestEditTextToFloat(EditCoeff)
    then ListBoxCoeff.Items[ListBoxCoeff.ItemIndex] := EditCoeff.Text;
  end;
end;

//--------------------------------------------------
//       
//--------------------------------------------------

//   
procedure TForm1.ButtonRunClick(Sender: TObject);
var Argument, Polynom : double;
    ReportStr : string;
begin
   if ProStrToFloat(EditArgument.Text,Argument)
   then begin
     Polynom := CalcPolynom (ListBoxCoeff.Items, Argument);
     // 
     ReportStr := 'P(' + EditArgument.Text + ') = '
               + FloatToStr(Polynom);
     MemoReport.Lines.Add(ReportStr);
   end;
end;

//--------------------------------------------------
//      
//--------------------------------------------------

procedure TForm1.ButtonReportClick(Sender: TObject);
begin
  case CBoxReportCmd.ItemIndex of
  0 : MemoReport.Clear;
  1 : ShowCoeffToReport(ListBoxCoeff.Items, MemoReport);
  end; // of case
end;

//--------------------------------------------------
//    
//--------------------------------------------------

end.

